require( "scripts/style.lua" );


SubMenuTipFont = {
	standardFont,
	24,
	BorderColor
};

SubMenuTitleFont = {
	standardFont,
	36,
	BorderColor
};

kTipFadeTime = 250;


function MakeMPNewIcon()
	if (GetStrSetting('enteredmultiplayer', '0') == '0') then
		return Group {
			Bitmap
			{
				x = 365,
				y = 60,
				image = "menu/new_label",
				name = "multiplayer_new", 
				SetStyle(DefaultStyle),
				Text
				{
					x = kCenter,
					y = kCenter,
					w = kMax,
					h = kMax,
					flags = kHAlignCenter + kVAlignCenter,
					label = "new"
				}			
			};
		};
	else
		return Group{};
	end
end

function MakeMyDinerNewIcon()
	if (GetStrSetting('enteredmydiner', '0') == '0') then
		return Group {
			Bitmap
			{
				x = 365,
				y = 105,
				image = "menu/new_label",
				name = "mydiner_new",
				SetStyle(DefaultStyle),
				
				Text
				{
					x = kCenter,
					y = kCenter,
					w = kMax,
					h = kMax,
					flags = kHAlignCenter + kVAlignCenter,
					label = "new"
				}
			};	
		}
	else
		return Group{};
	end
end	

MakeDialog
{
	PopThroughBitmap
	{
		name="backgroundimage",
		image="backgrounds/popup",
		x=kCenter,
		y=kCenter,
		
		Text
		{
			label = 'playmenu',
			font = SubMenuTitleFont,
			x = 0, w = kMax,
			y = 30, h = kMax,
			flags = kHAlignCenter + kVAlignTop
		};
			
			
		SetStyle(StandardButtonStyle);
		
		Button
		{
			x=50,
			y=80,
			name="gamemode1",
			label="gamemode1",
			command=
				function()
					if (LimitedTrialExpired(true)) then
						DisplayDialog { 
							"scripts/ok.lua", 
							body ="timetrialexpired",
							title = ""
						};
					else
						SetDefaultGameSettings();
						if (Login(true, false)) then
							CloseAllWindows();
							LaunchMapScreen(false);
						end
					end
				end
		},
		
		Button
		{
			x=50,
			y=125,
			name="gamemode2",
			label="gamemode2",
			command=
				function()
					if (IsFirstPeek()) then
						DisplayDialog{
							'scripts/ok.lua', 
							body ='notinfirstpeek',
							title = ''
						};
					else
						SetDefaultGameSettings();
						SetCurrentGameMode(1);
						if (Login(false, false)) then
							CloseAllWindows();
							LaunchMapScreen(false);
						end
					end
				end
		},
					

		
		Button
		{
			x=245,
			y=80,
			name="multiplayer",
			label="multiplayer",
			command=
				function()
					if (Login(false, false)) then
						SetMultiplayerVisited();
						LaunchMPEntry();						
					end
					
				end
		};
		
		
		
		Button
		{
			x=245,
			y=125,
			name="mydiner",
			label="playmydiner",
			type = kPush,
			command=
				function()
					if (Login(false, false)) then
						MetricEvent(eMyDinerMainMenuVisits);
						SetMyDinerVisited();						
						SelectMyDiner();
					end
				end
		},
		
		MakeMPNewIcon();
		MakeMyDinerNewIcon();
				
		Button
		{
			x=kCenter-10,
			y=215,
			name="back",
			label="back",
			command=
				function()
					PopModal("scripts/mydinerdashsubmenu.lua");
				end
		},
		
		
		SetStyle(DefaultStyle);
			
	},
}

